/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.worldgen.liquidregion;

import com.google.gson.annotations.SerializedName;
import com.yungnickyoung.minecraft.bettercaves.worldgen.liquidregion.LiquidRegions;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.class_2960;
import net.minecraft.class_3218;

public class LiquidRegionsController {
    public static LiquidRegionsController INSTANCE;
    private final transient ConcurrentMap<class_3218, LiquidRegions> regionsByLevel = new ConcurrentHashMap<class_3218, LiquidRegions>();
    @SerializedName(value="liquidRegions")
    private final Map<class_2960, LiquidRegions.Settings> settingsByDimensionId = new ConcurrentHashMap<class_2960, LiquidRegions.Settings>();

    public static LiquidRegionsController getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LiquidRegionsController();
        }
        return INSTANCE;
    }

    public static void useDefaultSettings() {
        LiquidRegionsController controller = new LiquidRegionsController();
        controller.settingsByDimensionId.put(class_2960.method_60656((String)"overworld"), LiquidRegions.Settings.DEFAULT.copy());
        INSTANCE = controller;
    }

    public boolean hasSettingsForLevel(class_3218 serverLevel) {
        class_2960 dimensionId = serverLevel.method_27983().method_29177();
        return this.settingsByDimensionId.containsKey(dimensionId);
    }

    public LiquidRegions getLiquidRegionsForServerLevel(class_3218 serverLevel) {
        return this.regionsByLevel.computeIfAbsent(serverLevel, sl -> {
            LiquidRegions.Settings settings = this.settingsByDimensionId.get(sl.method_27983().method_29177());
            if (settings == null) {
                throw new IllegalStateException("No LiquidRegions settings found for dimension: " + String.valueOf(sl.method_27983().method_29177()));
            }
            return new LiquidRegions((class_3218)sl, settings);
        });
    }
}

